/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.devices;

/**
 * Class to test the buffer queue.
 */
class BufferQueueTest extends Thread
{
	BufferQueue bq;
	int role;
	boolean bRunning;
	RTPPacketFactory factory;
	
	public static final int PACKET_SIZE = 400;
		
	public static final int PRODUCER = 0;
	public static final int CONSUMER = 1;
	
	public BufferQueueTest (BufferQueue bq, int role)
	{
		this.bq = bq;
		this.role = role;
		bRunning = true;
		start();
	}
	
	public BufferQueueTest (BufferQueue bq, int role, RTPPacketFactory factory)
	{
		this.factory = factory;
		this.bq = bq;
		this.role = role;
		bRunning = true;
		start();
		
	}
	
	public void run()
	{
		if (role == PRODUCER)
		{
			byte[] buf1 = new byte[PACKET_SIZE];
			byte[] buf2 = new byte[PACKET_SIZE];
			byte[] buf3 = new byte[PACKET_SIZE];
			
			FECBuffer buffer = new FECBuffer(PACKET_SIZE);
		
			buffer.pack(buf1);
			buffer.pack(buf2);
			byte[] buf = buffer.pack(buf3);
			
			byte [] rtpData = factory.createRTPPacket(buf);
			RTPPacket rtpFirstPacket = factory.getRTPPacket(rtpData);
			bq.put(rtpFirstPacket);
			
			while (bRunning)
			{
				rtpData = factory.createRTPPacket(buf);
				rtpFirstPacket = factory.getRTPPacket(rtpData);
				bq.put(rtpFirstPacket);	
				try
				{	
					Thread.sleep(40);
				}
				catch (InterruptedException ie)
				{
					ie.printStackTrace();
				}
			}
		}
		else
		{
			while (bRunning)
				if (bq.get() == null)
					System.out.println("Got a silence packet");
		}
		
		
	}
	
	
	
	public static void main(String args[]) throws Exception
	{
		RTPPacketFactory factory = new RTPPacketFactory();

		BufferQueue bq = new BufferQueue(PACKET_SIZE / 8, PACKET_SIZE,  factory.getSequenceNumber() & 0xffff);
		BufferQueueTest prod = new BufferQueueTest(bq, BufferQueueTest.PRODUCER, factory);
		BufferQueueTest cons = new BufferQueueTest(bq, BufferQueueTest.CONSUMER);
		
		System.in.read();
		cons.bRunning = false;
		System.in.read();
		prod.bRunning = false;
		System.in.read();
	}
}
